%%
% Splitting of a peak as a function of backscattering

%% 

clear all;
close all;

% Load band structure data values
load('../Data/experiment_compare_data_horizontal.mat');
load('../Data/experiment_compare_data_slant.mat');

% Get the range of energy values
energy_min = max(min(data_horz.energy), min(data_slant.energy));
energy_max = min(max(data_horz.energy), max(data_slant.energy));

% Range of values of energy to check out for peak position
num_energy = 5e6;
energy = linspace(energy_min, energy_max, num_energy);

% Find the k value for each energy via interpolation
kinterp.horz = interp1(data_horz.energy, data_horz.k, energy, 'spline');
kinterp.slant = interp1(data_slant.energy, data_slant.k, energy, 'spline');

% Get g(beta) for each energy
ct.amech = 1.570496020158940e-05;
% Christmas tree parameters (length in number of snowflake unit cells)
ct.tri_side = 25.628000572; % circumference length/3
ct.horz_bot = 14/32*ct.tri_side; % Horizontal bottom length
ct.slant_bot = 6/32*ct.tri_side; % Slanted bottom length

% Shift in spectrum
shift_freq = -8.398152966953367e6;

beta1 = kinterp.horz*ct.horz_bot*ct.amech;
beta2 = kinterp.slant*ct.slant_bot*ct.amech;
beta3 = kinterp.horz*(ct.tri_side - ct.horz_bot)/2*ct.amech;
beta4 = kinterp.slant*(ct.tri_side - ct.slant_bot)*ct.amech;

% Boundary of the energy within which the splitted peaks are located
peak_index = 5;
peak_min = 323.4e6;
peak_max = 324.6e6;

num_r1 = 30;
split = zeros(1, num_r1);
r1_max = 0.98; r1_min = 0.01;
r1 = linspace(r1_min, r1_max, num_r1);

for j=1:30
    
    % Reflection and transmission co-efficients
    scat.r1 = 1i*r1(j); 
    scat.t1 = sqrt(1 - abs(scat.r1)^2);
    scat.r2 = scat.r1;
    scat.t2 = sqrt(1 - abs(scat.r2)^2);

    % Quadratic equation of the form: x^2+ax+1=0
    a = 1/(scat.t1^6.*scat.t2.*conj(scat.t1)^6.*conj(scat.t2)).*exp(-i.*(beta1+2.*(beta2+beta3+beta4))).*...
      (-exp(2i.*(beta1+2.*(beta2+beta3+beta4))).*scat.t1^6.*scat.t2+exp(4i.*(beta2+beta4)).*...
     scat.t1^6.*scat.t2.*conj(scat.r1)^6+2.*exp(2i.*(beta1+beta2+2.*(beta3+beta4))).*...
     scat.r1^2.*scat.t1^4.*scat.t2.*conj(scat.t1)^2+exp(4i.*(beta3+beta4)).*scat.r1^2.*scat.t1^2.*scat.t2.*...
     conj(scat.t1)^4-exp(2i.*(beta1+2.*(beta3+beta4))).*scat.r1^4.*scat.t1^2.*scat.t2.*conj(scat.t1)^4-...
      exp(2i.*(beta3+beta4)).*scat.r1.*scat.t1.*scat.t2.*conj(scat.r2).*conj(scat.t1).*...
      (exp(2i.*(beta1+2.*beta2+beta3)).*scat.t1^4-exp(2i.*(beta1+beta2)).*...
      (-1+2.*exp(2i.*beta3).*scat.r1^2).*scat.t1^2.*conj(scat.t1)^2+(-1+exp(2i.*beta1).*scat.r1^2).*...
      (-1+exp(2i.*beta3).*scat.r1^2).*conj(scat.t1)^4)+exp(2i.*(beta1+2.*beta2+2.*beta3+beta4)).*...
     scat.r1.*scat.r2.*scat.t1^5.*conj(scat.t1).*conj(scat.t2)+exp(2i.*(beta1+2.*(beta2+beta3))).*scat.r1^2.*...
     scat.t1^4.*conj(scat.t1)^2.*conj(scat.t2)+exp(2i.*(beta1+beta2+beta3+beta4)).*scat.r1.*scat.r2.*...
     scat.t1^3.*conj(scat.t1)^3.*conj(scat.t2)-2.*exp(2i.*(beta1+beta2+2.*beta3+beta4)).*scat.r1^3.*...
      scat.r2.*scat.t1^3.*conj(scat.t1)^3.*conj(scat.t2)+2.*exp(2i.*(beta1+beta2+beta3)).*scat.r1^2.*scat.t1^2.*...
     conj(scat.t1)^4.*conj(scat.t2)-2.*exp(2i.*(beta1+beta2+2.*beta3)).*scat.r1^4.*scat.t1^2.*...
     conj(scat.t1)^4.*conj(scat.t2)+exp(2i.*(beta3+beta4)).*scat.r1.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)-...
      exp(2i.*(beta1+beta3+beta4)).*scat.r1^3.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)-...
      exp(2i.*(2.*beta3+beta4)).*scat.r1^3.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)+...
      exp(2i.*(beta1+2.*beta3+beta4)).*scat.r1^5.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)-...
     conj(scat.t1)^6.*conj(scat.t2)+exp(2i.*beta1).*scat.r1^2.*conj(scat.t1)^6.*conj(scat.t2)+...
      2.*exp(2i.*beta3).*scat.r1^2.*conj(scat.t1)^6.*conj(scat.t2)-exp(4i.*beta3).*scat.r1^4.*conj(scat.t1)^6.*...
     conj(scat.t2)-2.*exp(2i.*(beta1+beta3)).*scat.r1^4.*conj(scat.t1)^6.*conj(scat.t2)+...
      exp(2i.*(beta1+2.*beta3)).*scat.r1^6.*conj(scat.t1)^6.*conj(scat.t2)+...
      exp(2i.*(2.*beta2+beta4)).*scat.t1^5.*conj(scat.r1)^5.*conj(scat.t1).*(scat.t2.*conj(scat.r2)-...
      scat.r2.*conj(scat.t2))-exp(2i.*beta2).*scat.t1^4.*conj(scat.r1)^4.*...
      (exp(2i.*(beta2+2.*beta4)).*(exp(2i.*beta1)+2.*exp(2i.*beta3)).*scat.t1^2.*scat.t2+...
      exp(2i.*(beta2+beta3+beta4)).*scat.r1.*scat.t1.*scat.t2.*conj(scat.r2).*conj(scat.t1)-...
      exp(2i.*(beta2+beta3+beta4)).*scat.r1.*scat.r2.*scat.t1.*conj(scat.t1).*conj(scat.t2)+conj(scat.t1)^2.*...
      (2.*exp(4i.*beta4).*scat.t2+exp(2i.*beta2).*conj(scat.t2)))+exp(2i.*beta2).*...
     scat.t1^3.*conj(scat.r1)^3.*conj(scat.t1).*(-exp(2i.*beta4).*scat.t2.*conj(scat.r2).*(exp(2i.*beta2).*...
      (exp(2i.*beta1)+exp(2i.*beta3)).*scat.t1^2+(2-exp(2i.*beta3).*scat.r1^2).*conj(scat.t1)^2)+...
      exp(2i.*(beta2+beta4)).*(exp(2i.*beta1)+exp(2i.*beta3)).*scat.r2.*scat.t1^2.*conj(scat.t2)-...
      exp(2i.*beta4).*(-2+exp(2i.*beta3).*scat.r1^2).*scat.r2.*conj(scat.t1)^2.*conj(scat.t2)+...
      2.*scat.r1.*scat.t1.*conj(scat.t1).*(exp(4i.*beta4).*(exp(2i.*beta1)+exp(2i.*beta3)).*scat.t2+...
      exp(2i.*(beta2+beta3)).*conj(scat.t2)))-scat.t1.*conj(scat.r1).*conj(scat.t1).*...
      (exp(2i.*beta4).*scat.t2.*conj(scat.r2).*(-exp(2i.*(beta1+2.*beta2+beta3)).*scat.t1^4+...
      exp(2i.*(beta2+beta3)).*(-1+2.*exp(2i.*beta1).*scat.r1^2+2.*exp(2i.*beta3).*scat.r1^2).*...
      scat.t1^2.*conj(scat.t1)^2-(-1+exp(2i.*beta1).*scat.r1^2).*(-1+exp(2i.*beta3).*scat.r1^2).*conj(scat.t1)^4)+...
      exp(2i.*(beta1+2.*beta2+beta3+beta4)).*scat.r2.*scat.t1^4.*conj(scat.t2)-exp(2i.*(beta2+beta3+beta4)).*...
      (-1+2.*exp(2i.*beta1).*scat.r1^2+2.*exp(2i.*beta3).*scat.r1^2).*scat.r2.*scat.t1^2.*conj(scat.t1)^2.*conj(scat.t2)+...
      exp(2i.*beta4).*(-1+exp(2i.*beta1).*scat.r1^2).*(-1+exp(2i.*beta3).*scat.r1^2).*scat.r2.*conj(scat.t1)^4.*...
      conj(scat.t2)+2.*exp(2i.*(beta2+beta3)).*scat.r1.*scat.t1^3.*conj(scat.t1).*(exp(4i.*beta4).*...
      (exp(2i.*beta1)+exp(2i.*beta3)).*scat.t2+exp(2i.*(beta1+beta2)).*conj(scat.t2))-...
      2.*scat.r1.*scat.t1.*conj(scat.t1)^3.*(exp(2i.*(beta3+2.*beta4)).*(-1+exp(2i.*beta1).*scat.r1^2).*scat.t2+...
      exp(2i.*beta2).*(exp(2i.*beta1)+exp(2i.*beta3)).*(-1+exp(2i.*beta3).*scat.r1^2).*...
      conj(scat.t2)))+scat.t1^2.*conj(scat.r1)^2.*(exp(2i.*(2.*beta2+beta3+2.*beta4)).*...
      (2.*exp(2i.*beta1)+exp(2i.*beta3)).*scat.t1^4.*scat.t2+exp(2i.*(beta2+beta4)).*scat.r1.*scat.t1.*...
      scat.t2.*conj(scat.r2).*conj(scat.t1).*(exp(2i.*(beta2+beta3)).*(exp(2i.*beta1)+...
      exp(2i.*beta3)).*scat.t1^2+(2.*exp(2i.*beta1)+2.*exp(2i.*beta3)-exp(2i.*(beta1+beta3)).*...
      scat.r1^2).*conj(scat.t1)^2)-exp(2i.*(2.*beta2+beta3+beta4)).*(exp(2i.*beta1)+...
      exp(2i.*beta3)).*scat.r1.*scat.r2.*scat.t1^3.*conj(scat.t1).*conj(scat.t2)+exp(2i.*(beta2+beta4)).*...
      scat.r1.*(-2.*exp(2i.*beta1)-2.*exp(2i.*beta3)+exp(2i.*(beta1+beta3)).*scat.r1^2).*...
      scat.r2.*scat.t1.*conj(scat.t1)^3.*conj(scat.t2)+conj(scat.t1)^4.*(-exp(4i.*beta4).*(-1+...
      exp(2i.*beta1).*scat.r1^2).*scat.t2-2.*exp(2i.*beta2).*(-1+exp(2i.*beta3).*scat.r1^2).*...
      conj(scat.t2))-exp(2i.*beta2).*scat.t1^2.*conj(scat.t1)^2.*(2.*exp(2i.*(beta3+2.*beta4)).*...
      (-1+exp(2i.*beta1).*scat.r1^2).*scat.t2-exp(2i.*beta2).*(exp(2i.*beta1)-...
      exp(4i.*beta3).*scat.r1^2).*conj(scat.t2))));

    % Peak positions
    [peak_pos, temp1, temp2] = find_roots_ene(energy, real(a)+2, kinterp);
    
    disp(j)
    
    % Splitting of individual peak
%     peak_pos = peak_pos + shift_freq;
%     index = find(peak_pos<peak_max & peak_pos>peak_min);
%     split(j) = peak_pos(index(2)) - peak_pos(index(1));
    
    % Mean splitting calculation
    odd = peak_pos(1:2:20);
    even = peak_pos(2:2:20);
    
    split(j) = mean(even - odd);
end

%% Plotting

figure(1)
hold on;
box on;
set(gca,'FontSize',18)
xlabel('Reflection co-efficient (r1)');
% ylabel(['Splitting of peak ' num2str(peak_index)]);
ylabel(['Mean splitting']);

for j=1:num_r1
   plot(r1(j), split(j), 'Color', 'blue', 'LineStyle', 'none',...
       'Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 20);
end